#include "h/XEEPROM.h"
#include "h/HardwareProfile.h"

void XEEInit(void)
{
	// 25LC1024
	EEPROM_CS_IO=1;
    ENC_CS_IO = 1;
//	EEPROM_CS_TRIS=0;
    ENC_CS_TRIS = 0;        // Make the Chip Select pin an output
    ENC_RST_IO      = 0;
    ENC_RST_TRIS    = 0;
    // Set up SPI
    ClearSPIDoneFlag();
    ENC_SPISTAT = 0;        // clear SPI
	RPOR4=0x0700;		// RP9= SPI Data Out
	RPOR5=0x0008;		// RP10= SPI Clk
	RPINR20=0x0A0B;		// RP11= SPI Data In
    ENC_SPICON1 = 0x0F;     // 1:1 primary prescale, 5:1 secondary prescale (8MHz  @ 40MIPS)
    ENC_SPICON2 = 0;
    ENC_SPICON1bits.CKE = 1;
    ENC_SPICON1bits.MSTEN = 1;
    ENC_SPISTATbits.SPIEN = 1;
}

XEE_RESULT XEEBeginWrite(DWORD address)
{
	BYTE Dummy;

	ENC_CS_IO=1;
	EEPROM_CS_IO=0;
	ClearSPIDoneFlag();
    EEPROM_SSPBUF = 0x06;				// WREN instruction
    WaitForDataByte();                  // Wait until transmitted
    Dummy = ENC_SSPBUF;
	EEPROM_CS_IO=1;

	EEPROM_CS_IO=0;
	ClearSPIDoneFlag();
   	EEPROM_SSPBUF = 0x02;				// WRITE instruction
    WaitForDataByte();                  // Wait until transmitted
    Dummy = ENC_SSPBUF;
   	ClearSPIDoneFlag();
   	EEPROM_SSPBUF = (address>>16) & 1;
    WaitForDataByte();                  // Wait until transmitted
    Dummy = ENC_SSPBUF;
   	ClearSPIDoneFlag();
    EEPROM_SSPBUF = (address>>8);
    WaitForDataByte();                  // Wait until transmitted
    Dummy = ENC_SSPBUF;
   	ClearSPIDoneFlag();
    EEPROM_SSPBUF = (address);
    WaitForDataByte();                  // Wait until transmitted
	return XEE_SUCCESS;
}

XEE_RESULT XEEWrite(BYTE val)
{
	BYTE Dummy;
    Dummy = ENC_SSPBUF;
	EEPROM_SSPBUF=val;
	WaitForDataByte();
	return XEE_SUCCESS;
}

void XEEWriteArray(BYTE *val, WORD wLen)
{
	while(wLen--)
	{
	XEEWrite(*val++);
	}	
	XEEEndWrite();
}

XEE_RESULT XEEEndWrite(void)
{
	EEPROM_CS_IO=1;
	return XEE_SUCCESS;
}

XEE_RESULT XEEBeginRead(DWORD address)
{
	BYTE Dummy;

	ENC_CS_IO=1;
	EEPROM_CS_IO=0;
	ClearSPIDoneFlag();
    EEPROM_SSPBUF = 0x03;				// READ instruction
    WaitForDataByte();                  // Wait until transmitted
    Dummy = ENC_SSPBUF;
	ClearSPIDoneFlag();
    EEPROM_SSPBUF = (address>>16) & 1;
    WaitForDataByte();                  // Wait until transmitted
    Dummy = ENC_SSPBUF;
	ClearSPIDoneFlag();
    EEPROM_SSPBUF = (address>>8);
    WaitForDataByte();                  // Wait until transmitted
    Dummy = ENC_SSPBUF;
	ClearSPIDoneFlag();
    EEPROM_SSPBUF = (address);
    WaitForDataByte();                  // Wait until transmitted
	return XEE_SUCCESS;
}

BYTE XEERead(void)
{
	BYTE Dummy;
    Dummy = ENC_SSPBUF;
	EEPROM_SSPBUF=0xFF;
	WaitForDataByte();
	return Dummy;
}

XEE_RESULT XEEReadArray(DWORD address, BYTE *buffer, BYTE length)
{
	XEEBeginRead(address);
	while(length--)
	{
	*buffer++=XEERead();
	}	
	XEEEndRead();
}

XEE_RESULT XEEEndRead(void)
{
    EEPROM_CS_IO=1;
	return XEE_SUCCESS;
}

BOOL XEEIsBusy(void)
{
	
}
